/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.xml.parser.impl;

import biz.netup.control.xml.parser.impl.ArrayTypeParser;
import biz.netup.control.xml.parser.impl.TypeParser;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class LongArrayParser
extends ArrayTypeParser {
    private static final Logger LOG = Logger.getLogger(LongArrayParser.class);

    @Override
    public TypeParser newInstance() {
        return new LongArrayParser();
    }

    @Override
    protected Class getItemClass() {
        return Long.TYPE;
    }

    @Override
    protected Object parseValueImpl() throws SAXException {
        Long l = null;
        if (this.text == null || this.text.length() == 0) {
            LOG.error("null or empty content cannot be parsed into a long value");
            throw new SAXException("IllegalContent");
        }
        try {
            l = Long.valueOf(this.text.toString());
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("the content cannot be parsed into a long value", numberFormatException);
            throw new SAXException("IllegalContent");
        }
        return l;
    }
}

