/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.xml.parser.impl;

import biz.netup.control.xml.parser.impl.ArrayTypeParser;
import biz.netup.control.xml.parser.impl.TypeParser;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class IntArrayParser
extends ArrayTypeParser {
    private static final Logger LOG = Logger.getLogger(IntArrayParser.class);

    @Override
    public TypeParser newInstance() {
        return new IntArrayParser();
    }

    @Override
    protected Class getItemClass() {
        return Integer.TYPE;
    }

    @Override
    protected Object parseValueImpl() throws SAXException {
        Integer n = null;
        if (this.text == null || this.text.length() == 0) {
            LOG.error("null or empty content cannot be parserd into an integer value");
            throw new SAXException("IllegalContent");
        }
        try {
            n = Integer.valueOf(this.text.toString());
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("the content cannot be parsed into an integer value", numberFormatException);
            throw new SAXException("IllegalContent");
        }
        return n;
    }
}

