/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.xml.parser.impl;

import biz.netup.control.xml.parser.impl.ArrayTypeParser;
import biz.netup.control.xml.parser.impl.TypeParser;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class DoubleArrayParser
extends ArrayTypeParser {
    private static final Logger LOG = Logger.getLogger(DoubleArrayParser.class);

    @Override
    public TypeParser newInstance() {
        return new DoubleArrayParser();
    }

    @Override
    protected Class getItemClass() {
        return Double.TYPE;
    }

    @Override
    protected Object parseValueImpl() throws SAXException {
        Double d = null;
        if (this.text == null || this.text.length() == 0) {
            LOG.error("null or empty content cannot be parsed into a double value");
            throw new SAXException("IllegalContent");
        }
        try {
            d = Double.valueOf(this.text.toString());
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("the content cannot be parsed into a double value", numberFormatException);
            throw new SAXException("IllegalContent");
        }
        return d;
    }
}

