/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.xml.parser.impl;

import biz.netup.control.xml.parser.impl.TypeParser;
import java.lang.reflect.Array;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class ArrayTypeParser
extends TypeParser {
    protected String namespaceURI = null;
    protected String localName = null;
    protected StringBuffer text = null;
    protected int size = -1;
    protected Object array = null;
    protected int currentIndex = 0;
    private static final Logger log = Logger.getLogger(ArrayTypeParser.class);

    @Override
    public abstract TypeParser newInstance();

    @Override
    protected Object parseValue() throws SAXException {
        return this.array;
    }

    protected abstract Class getItemClass();

    protected abstract Object parseValueImpl() throws SAXException;

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        if (!this.inside) {
            throw new IllegalStateException();
        }
        if (log.isDebugEnabled()) {
            string4 = "";
            if (string != null && string.length() > 0) {
                string4 = string + ":";
            }
            string4 = string4 + string2;
            log.debug("startElement: " + string4);
        }
        if (this.localName == null) {
            this.namespaceURI = string;
            this.localName = string2;
            string4 = attributes.getValue("size");
            if (string4 != null) {
                try {
                    this.size = Integer.parseInt(string4);
                    this.array = Array.newInstance(this.getItemClass(), this.size);
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("size attribute is not an integer");
                    throw new SAXException("Error parsing size attribute");
                }
            }
        } else if (this.text == null && "item".equals(string2)) {
            this.text = new StringBuffer();
        } else {
            throw new SAXException("UnexpectedElement");
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        if (log.isDebugEnabled()) {
            object = "";
            if (string != null && string.length() > 0) {
                object = string + ":";
            }
            object = (String)object + string2;
            log.debug("endElement " + (String)object);
        }
        if (!this.inside) {
            log.error("the parser is in an illegal state to end an element");
            throw new IllegalStateException();
        }
        if (this.text != null) {
            object = this.parseValueImpl();
            if (this.currentIndex >= this.size) {
                String string4 = "unexpected element, expected " + this.size + " elements";
                log.error(string4);
                throw new SAXException(string4);
            }
            Array.set(this.array, this.currentIndex, object);
            ++this.currentIndex;
            this.text = null;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("array.size() = " + Array.getLength(this.array) + ", this.size = " + this.size);
            }
            if (this.size != -1 && this.currentIndex != this.size) {
                object = "expected " + this.size + " elements, found " + this.currentIndex;
                log.error(object);
                throw new SAXException((String)object);
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        boolean bl = this.isWhitespace(cArray, n, n2);
        if (log.isDebugEnabled()) {
            String string = this.getThumbnail(cArray, n, n2, bl);
            log.debug("characters: " + string);
        }
        if (!this.inside) {
            log.error("the parser is in an illegal state to accept characters");
            throw new IllegalStateException();
        }
        if (this.text != null) {
            this.text.append(cArray, n, n2);
        } else if (!bl) {
            throw new SAXException("UnexpectedData");
        }
    }
}

