/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.impl;

import biz.netup.control.transport.ConnectionResetListener;
import biz.netup.control.transport.ssl.SSLManager;
import biz.netup.control.transport.urfa.UrfaConnector;
import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import biz.netup.control.transport.urfa.UrfaManagerException;
import biz.netup.control.transport.urfa.impl.ConnectionFactory;
import biz.netup.control.transport.urfa.impl.ConnectionImpl;
import biz.netup.control.transport.urfa.impl.UrfaInvocationImpl;
import biz.netup.projects.utmadmin.gui.logindialog.DialogSplash;
import biz.netup.projects.utmadmin.gui.logindialog.ReconnectDialog;
import biz.netup.utmutils.control.Utils;
import biz.netup.utmutils.swing.localization.ResourceBundleWrapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class UrfaManagerImpl
implements UrfaManager,
UrfaConnector {
    public static final int DEFAULT_MIN_POOL_SIZE = 3;
    public static final int DEFAULT_MAX_POOL_SIZE = 5;
    public static final long DEFAULT_WAIT_TIME = 600000L;
    private Set<Integer> permittedFunctions = new TreeSet<Integer>();
    private boolean checkPermissions;
    private ObjectPool pool = null;
    private int minPoolSize = 3;
    private int maxPoolSize = 5;
    private long waitTime = 600000L;
    private SSLManager sslManager;
    public ConnectionResetListener connectionResetListener;
    private ResourceBundleWrapper resource = Utils.getResource();
    private String host;
    private String password;
    private int port;
    private String login;
    private static final int getPermittedFunctionsFIDadmin = 17431;
    private static final int getPermittedFunctionsFIDdealer = 1879048266;
    private static final Logger LOGGER = Logger.getLogger(UrfaManagerImpl.class);

    private UrfaManagerImpl() {
    }

    public static UrfaManagerImpl getInstance() {
        return UrfaManagerHolder.INSTANCE;
    }

    @Override
    public void setConnectionResetListener(ConnectionResetListener connectionResetListener) {
        this.connectionResetListener = connectionResetListener;
    }

    public void init(int n, int n2, long l) {
        if (n < 1 || n2 < n || n2 > 100) {
            LOGGER.error("illegal pool definition");
            throw new IllegalArgumentException("Illegal pool definition");
        }
        if (l < 0L) {
            LOGGER.error("illegal waitTime value");
            throw new IllegalArgumentException("Illegal waitTime value");
        }
        this.minPoolSize = n;
        this.maxPoolSize = n2;
        this.waitTime = l;
    }

    public void setSSLManager(SSLManager sSLManager) {
        if (sSLManager == null) {
            LOGGER.error("Illegal sslManager value");
            throw new IllegalArgumentException("sslManager");
        }
        this.sslManager = sSLManager;
    }

    public void reconnect() throws UrfaManagerException {
        this.connect(this.host, this.port, this.login, this.password);
    }

    @Override
    public void connect(String string, int n, String string2, String string3) throws UrfaManagerException {
        GenericObjectPool genericObjectPool;
        InetAddress inetAddress;
        this.host = string;
        this.port = n;
        this.login = string2;
        this.password = string3;
        if (this.minPoolSize < 1 || this.maxPoolSize < this.minPoolSize || this.maxPoolSize > 100) {
            LOGGER.error("illegal pool definition");
            throw new IllegalStateException("Illegal pool definition");
        }
        if (this.waitTime < 0L) {
            LOGGER.error("illegal waitTime value");
            throw new IllegalStateException("Illegal waitTime value");
        }
        if (this.sslManager == null) {
            LOGGER.error("illegal sslManager value");
            throw new IllegalStateException("Illegal sslManager value");
        }
        if (string == null || string2 == null || string3 == null || n == 0) {
            LOGGER.error("null agruments");
            throw new IllegalArgumentException();
        }
        DialogSplash.setStatus(this.resource.getString("Connecting to host") + " " + string + "..");
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            LOGGER.error("unknown host exception");
            throw new UrfaManagerException("UnknownHostException", unknownHostException);
        }
        if (this.pool != null) {
            try {
                this.pool.clear();
            }
            catch (Exception exception) {
                LOGGER.error("failed to clear connections pool");
            }
        }
        ConnectionFactory connectionFactory = new ConnectionFactory(inetAddress, n, string2, string3, this.sslManager);
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = this.maxPoolSize;
        config.maxIdle = this.minPoolSize;
        config.whenExhaustedAction = 1;
        config.maxWait = this.waitTime;
        try {
            genericObjectPool = new GenericObjectPool((PoolableObjectFactory)connectionFactory, config);
        }
        catch (Exception exception) {
            LOGGER.error("pool creation error");
            throw new UrfaManagerException("Pool creation error", exception);
        }
        for (int i = 0; i < this.minPoolSize; ++i) {
            try {
                genericObjectPool.addObject();
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Error adding object to the pool", exception);
                throw new UrfaManagerException(exception.getMessage(), exception);
            }
        }
        this.pool = genericObjectPool;
        try {
            this.getPermittedFunctions();
        }
        catch (UrfaException urfaException) {
            LOGGER.error("Can't obtain granted functions list");
            throw new UrfaManagerException(urfaException.getMessage(), urfaException);
        }
    }

    public boolean isPermitted(int n) {
        return this.permittedFunctions.contains(n);
    }

    public boolean isPermitted(int[] nArray) {
        if (nArray == null) {
            return true;
        }
        for (int n : nArray) {
            if (this.permittedFunctions.contains(n)) continue;
            if (!Utils.isAdmin() && n < 0x70000000) {
                Utils.getLogger().log(10, "check for admin function " + n + " in dealer mode");
            } else {
                String string = n < 0 ? "-0x" + Integer.toHexString(Math.abs(n)) : "0x" + Integer.toHexString(n);
                Utils.getLogger().log(10, "function " + string + " not permitted");
            }
            return false;
        }
        return true;
    }

    @Override
    public UrfaInvocation startInvocation(int n) throws UrfaManagerException {
        ConnectionImpl connectionImpl;
        if (this.pool == null) {
            LOGGER.error("Manager already destroyed");
            throw new UrfaManagerException("Already destroed");
        }
        if (this.checkPermissions && !this.isPermitted(n)) {
            String string = n < 0 ? "-0x" + Integer.toHexString(Math.abs(n)) : "0x" + Integer.toHexString(n);
            LOGGER.error("function " + string + " not permitted \n" + this.permittedFunctions);
            throw new UrfaManagerException("Not permitted to call " + string + " function");
        }
        LOGGER.info("Idle in pool: " + this.pool.getNumIdle());
        try {
            connectionImpl = (ConnectionImpl)this.pool.borrowObject();
        }
        catch (Exception exception) {
            LOGGER.error("pool allocation error");
            throw new UrfaManagerException(exception.getMessage(), exception);
        }
        try {
            if (!connectionImpl.isAlive()) {
                LOGGER.warn("connection is dead, trying to reconnect");
                ReconnectDialog reconnectDialog = new ReconnectDialog();
                reconnectDialog.setVisible(true);
                try {
                    connectionImpl = (ConnectionImpl)this.pool.borrowObject();
                }
                catch (Exception exception) {
                    LOGGER.error("pool allocation error");
                    throw new UrfaManagerException(exception.getMessage(), exception);
                }
                LOGGER.warn("reconnected");
            }
            if (connectionImpl.isClosed()) {
                LOGGER.warn("connection closed, trying to reconnect");
                connectionImpl.reopen();
                LOGGER.warn("reconnected");
            }
        }
        catch (Exception exception) {
            LOGGER.error("reconnecting failed");
            throw new UrfaManagerException(exception.getMessage(), exception);
        }
        return new UrfaInvocationImpl(connectionImpl, n, this);
    }

    @Override
    public void disconnect() throws UrfaManagerException {
        if (this.pool == null) {
            LOGGER.error("manager already closed");
            throw new UrfaManagerException("Already destroyed");
        }
        try {
            this.pool.close();
        }
        catch (Exception exception) {
            LOGGER.error("failed: " + exception.getMessage());
            throw new UrfaManagerException(exception.getMessage(), exception);
        }
        this.pool = null;
        LOGGER.info("ConnectionManager destroyed");
    }

    protected void freeConnection(ConnectionImpl connectionImpl) throws UrfaManagerException {
        try {
            this.pool.returnObject(connectionImpl);
        }
        catch (Exception exception) {
            LOGGER.error("pool error");
            throw new UrfaManagerException(exception.getMessage(), exception);
        }
    }

    private void getPermittedFunctions() throws UrfaManagerException {
        int n;
        Object object;
        this.checkPermissions = false;
        this.permittedFunctions.clear();
        try {
            int n2;
            object = Utils.isAdmin() ? this.startInvocation(17431) : this.startInvocation(1879048266);
            object.invoke();
            object.getInt();
            object.getString();
            object.getIpAddress();
            object.getInt();
            object.getIpAddress();
            object.getInt();
            n = object.getInt();
            for (n2 = 0; n2 < n; ++n2) {
                object.getInt();
                object.getString();
                object.getString();
            }
            n = object.getInt();
            for (n2 = 0; n2 < n; ++n2) {
                this.permittedFunctions.add(object.getInt());
                object.getString();
                object.getString();
            }
            object.close();
        }
        catch (UrfaException urfaException) {
            LOGGER.error("can't get functions list");
            throw new UrfaManagerException(urfaException.getMessage(), urfaException);
        }
        if (!Utils.isAdmin()) {
            object = this.permittedFunctions.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                if (n >= 0x70000000 && n <= Integer.MAX_VALUE) continue;
                throw new UrfaManagerException(Utils.getResource().getString("Use admin module"));
            }
        }
        this.checkPermissions = true;
    }

    private static class UrfaManagerHolder {
        private static final UrfaManagerImpl INSTANCE = new UrfaManagerImpl();

        private UrfaManagerHolder() {
        }
    }
}

