/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import biz.netup.control.transport.urfa.functions.UrfaPushToReport;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UrfaTelSupplierPaymentsReport
extends UrfaPushToReport {
    private boolean invoked = false;
    private int inSupplierId = 0;
    private int inStartDate;
    private int inEndDate = (int)(System.currentTimeMillis() / 1000L);
    private Map<Integer, String> inCurrencyMap;
    private int outPaymentsCount;

    public UrfaTelSupplierPaymentsReport(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public UrfaTelSupplierPaymentsReport(UrfaManager urfaManager, ReportTab reportTab) {
        super(urfaManager, reportTab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(66326);
        try {
            urfaInvocation.putInt(this.inSupplierId);
            urfaInvocation.putInt(this.inStartDate);
            urfaInvocation.putInt(this.inEndDate);
            urfaInvocation.invoke();
            int n = urfaInvocation.getInt();
            if (n != -1) {
                this.outPaymentsCount = urfaInvocation.getInt();
                for (int i = 0; i < this.outPaymentsCount; ++i) {
                    this.row = new HashMap();
                    this.row.put("payment summ", urfaInvocation.getDouble());
                    this.row.put("currency type", this.inCurrencyMap.get(urfaInvocation.getInt()));
                    Long l = Long.parseLong(String.valueOf(urfaInvocation.getInt()));
                    Date date = new Date(l * 1000L);
                    String string = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(date);
                    this.row.put("payment date", string);
                    this.row.put("payment comment", urfaInvocation.getString());
                    if (this.addToReport(this.row)) continue;
                    return;
                }
            }
        }
        finally {
            if (!this.exit) {
                urfaInvocation.close();
            }
        }
    }

    public void setSupplierId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inSupplierId = n;
    }

    public void setCurrencyMap(Map<Integer, String> map) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inCurrencyMap = map;
    }

    public void setStartDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inStartDate = n;
    }

    public void setEndDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inEndDate = n;
    }

    public int getPaymentsCount() {
        if (this.invoked) {
            return this.outPaymentsCount;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

