/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import biz.netup.control.transport.urfa.functions.UrfaPushToReport;
import biz.netup.utmutils.swing.tab.ReportTab;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class UrfaTelSupplierChargesReport
extends UrfaPushToReport {
    private boolean invoked = false;
    private int inSupplierId = 0;
    private int inStartDate;
    private int inEndDate = (int)(System.currentTimeMillis() / 1000L);
    private int outChargesCount;

    public UrfaTelSupplierChargesReport(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public UrfaTelSupplierChargesReport(UrfaManager urfaManager, ReportTab reportTab) {
        super(urfaManager, reportTab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(66338);
        try {
            urfaInvocation.putInt(this.inSupplierId);
            urfaInvocation.putInt(this.inStartDate);
            urfaInvocation.putInt(this.inEndDate);
            urfaInvocation.invoke();
            int n = urfaInvocation.getInt();
            if (n != -1) {
                this.outChargesCount = urfaInvocation.getInt();
                for (int i = 0; i < this.outChargesCount; ++i) {
                    this.row = new HashMap();
                    this.row.put("account id", urfaInvocation.getInt());
                    this.row.put("user id", urfaInvocation.getInt());
                    this.row.put("user login", urfaInvocation.getString());
                    this.row.put("session id", urfaInvocation.getInt());
                    this.row.put("customer cost", urfaInvocation.getDouble());
                    this.row.put("customer cost_with_tax", urfaInvocation.getDouble());
                    this.row.put("supplier cost", urfaInvocation.getDouble());
                    this.row.put("supplier cost_with_tax", urfaInvocation.getDouble());
                    this.row.put("calling station_id", urfaInvocation.getString());
                    this.row.put("called station_id", urfaInvocation.getString());
                    this.row.put("duration", urfaInvocation.getLong());
                    Long l = Long.parseLong(String.valueOf(urfaInvocation.getInt()));
                    Date date = new Date(l * 1000L);
                    String string = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(date);
                    this.row.put("charge date", string);
                    this.row.put("charge duration", urfaInvocation.getLong());
                    if (this.addToReport(this.row)) continue;
                    return;
                }
            }
        }
        finally {
            if (!this.exit) {
                urfaInvocation.close();
            }
        }
    }

    public void setSupplierId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inSupplierId = n;
    }

    public void setStartDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inStartDate = n;
    }

    public void setEndDate(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inEndDate = n;
    }

    public int getChargesCount() {
        if (this.invoked) {
            return this.outChargesCount;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

