/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaReportDealerPayments {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inDealerId;
    private int inTimeStart;
    private int inTimeEnd;
    private int outPaymentsCount;
    private double outPaymentsSum;

    public UrfaReportDealerPayments(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(73743);
        try {
            urfaInvocation.putInt(this.inDealerId);
            urfaInvocation.putInt(this.inTimeStart);
            urfaInvocation.putInt(this.inTimeEnd);
            urfaInvocation.invoke();
            this.outPaymentsCount = urfaInvocation.getInt();
            this.outPaymentsSum = urfaInvocation.getDouble();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setDealerId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inDealerId = n;
    }

    public void setTimeStart(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inTimeStart = n;
    }

    public void setTimeEnd(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inTimeEnd = n;
    }

    public int getPaymentsCount() {
        if (this.invoked) {
            return this.outPaymentsCount;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getPaymentsSum() {
        if (this.invoked) {
            return this.outPaymentsSum;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

