/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import java.net.InetAddress;

public class UrfaRadiusDropSession {
    private UrfaManager manager;
    private boolean invoked = false;
    private String inAcctSessionId;
    private InetAddress inNasIp;
    private int outErrorCode;

    public UrfaRadiusDropSession(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(4210);
        try {
            urfaInvocation.putString(this.inAcctSessionId);
            urfaInvocation.putIpAddress(this.inNasIp);
            urfaInvocation.invoke();
            this.outErrorCode = urfaInvocation.getInt();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setAcctSessionId(String string) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inAcctSessionId = string;
    }

    public void setNasIp(InetAddress inetAddress) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inNasIp = inetAddress;
    }

    public int getErrorCode() {
        if (this.invoked) {
            return this.outErrorCode;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

