/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import java.net.InetAddress;

public class UrfaGetSwitch {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inId;
    private int outId;
    private String outName;
    private String outLocation;
    private int outType;
    private int outPortsCount;
    private String outRemoteId;
    private InetAddress outAddress;
    private String outLogin;
    private String outPassword;

    public UrfaGetSwitch(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(4432);
        try {
            urfaInvocation.putInt(this.inId);
            urfaInvocation.invoke();
            this.outId = urfaInvocation.getInt();
            this.outName = urfaInvocation.getString();
            this.outLocation = urfaInvocation.getString();
            this.outType = urfaInvocation.getInt();
            this.outPortsCount = urfaInvocation.getInt();
            this.outRemoteId = urfaInvocation.getString();
            this.outAddress = urfaInvocation.getIpAddress();
            this.outLogin = urfaInvocation.getString();
            this.outPassword = urfaInvocation.getString();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inId = n;
    }

    public int getId() {
        if (this.invoked) {
            return this.outId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getName() {
        if (this.invoked) {
            return this.outName;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getLocation() {
        if (this.invoked) {
            return this.outLocation;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getType() {
        if (this.invoked) {
            return this.outType;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getPortsCount() {
        if (this.invoked) {
            return this.outPortsCount;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getRemoteId() {
        if (this.invoked) {
            return this.outRemoteId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress getAddress() {
        if (this.invoked) {
            return this.outAddress;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getLogin() {
        if (this.invoked) {
            return this.outLogin;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getPassword() {
        if (this.invoked) {
            return this.outPassword;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

