/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaGetStreet {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inStreetId;
    private int outStreetId;
    private String outCountry;
    private String outRegion;
    private String outCity;
    private String outStreet;

    public UrfaGetStreet(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(10264);
        try {
            urfaInvocation.putInt(this.inStreetId);
            urfaInvocation.invoke();
            this.outStreetId = urfaInvocation.getInt();
            this.outCountry = urfaInvocation.getString();
            this.outRegion = urfaInvocation.getString();
            this.outCity = urfaInvocation.getString();
            this.outStreet = urfaInvocation.getString();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setStreetId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inStreetId = n;
    }

    public int getStreetId() {
        if (this.invoked) {
            return this.outStreetId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getCountry() {
        if (this.invoked) {
            return this.outCountry;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getRegion() {
        if (this.invoked) {
            return this.outRegion;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getCity() {
        if (this.invoked) {
            return this.outCity;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getStreet() {
        if (this.invoked) {
            return this.outStreet;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

