/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaGetSlinkShaping {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inSlinkId;
    private int outResult;
    private int outFlags;
    private int outTurbomodeSettingsId;
    private String outIncomingRate;
    private String outOutgoingRate;
    private int outTurboModeStart;
    private int outTurboModeEnd;
    private long outIncomingConsumptionLeft;
    private long outOutgoingConsumptionLeft;

    public UrfaGetSlinkShaping(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(73737);
        try {
            urfaInvocation.putInt(this.inSlinkId);
            urfaInvocation.invoke();
            this.outResult = urfaInvocation.getInt();
            this.outFlags = urfaInvocation.getInt();
            this.outTurbomodeSettingsId = urfaInvocation.getInt();
            this.outIncomingRate = urfaInvocation.getString();
            this.outOutgoingRate = urfaInvocation.getString();
            this.outTurboModeStart = urfaInvocation.getInt();
            this.outTurboModeEnd = urfaInvocation.getInt();
            this.outIncomingConsumptionLeft = urfaInvocation.getLong();
            this.outOutgoingConsumptionLeft = urfaInvocation.getLong();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setSlinkId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inSlinkId = n;
    }

    public int getResult() {
        if (this.invoked) {
            return this.outResult;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getFlags() {
        if (this.invoked) {
            return this.outFlags;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getTurbomodeSettingsId() {
        if (this.invoked) {
            return this.outTurbomodeSettingsId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getIncomingRate() {
        if (this.invoked) {
            return this.outIncomingRate;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getOutgoingRate() {
        if (this.invoked) {
            return this.outOutgoingRate;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getTurboModeStart() {
        if (this.invoked) {
            return this.outTurboModeStart;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getTurboModeEnd() {
        if (this.invoked) {
            return this.outTurboModeEnd;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public long getIncomingConsumptionLeft() {
        if (this.invoked) {
            return this.outIncomingConsumptionLeft;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public long getOutgoingConsumptionLeft() {
        if (this.invoked) {
            return this.outOutgoingConsumptionLeft;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

