/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;
import java.net.InetAddress;

public class UrfaGetDhcpPool {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inId;
    private int outId;
    private InetAddress outGateway;
    private InetAddress outNetmask;
    private InetAddress outDns1Server;
    private InetAddress outDns2Server;
    private InetAddress outNtpServer;
    private String outDomainName;
    private int outBlockPoolId;
    private int outLeaseTime;
    private int outFlags;
    private int outRangesSize;
    private InetAddress[] outFirstAddr;
    private InetAddress[] outLastAddr;

    public UrfaGetDhcpPool(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(1792);
        try {
            urfaInvocation.putInt(this.inId);
            urfaInvocation.invoke();
            this.outId = urfaInvocation.getInt();
            this.outGateway = urfaInvocation.getIpAddress();
            this.outNetmask = urfaInvocation.getIpAddress();
            this.outDns1Server = urfaInvocation.getIpAddress();
            this.outDns2Server = urfaInvocation.getIpAddress();
            this.outNtpServer = urfaInvocation.getIpAddress();
            this.outDomainName = urfaInvocation.getString();
            this.outBlockPoolId = urfaInvocation.getInt();
            this.outLeaseTime = urfaInvocation.getInt();
            this.outFlags = urfaInvocation.getInt();
            this.outRangesSize = urfaInvocation.getInt();
            this.outFirstAddr = new InetAddress[this.outRangesSize];
            this.outLastAddr = new InetAddress[this.outRangesSize];
            for (int i = 0; i < this.outRangesSize; ++i) {
                this.outFirstAddr[i] = urfaInvocation.getIpAddress();
                this.outLastAddr[i] = urfaInvocation.getIpAddress();
            }
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inId = n;
    }

    public int getId() {
        if (this.invoked) {
            return this.outId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress getGateway() {
        if (this.invoked) {
            return this.outGateway;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress getNetmask() {
        if (this.invoked) {
            return this.outNetmask;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress getDns1Server() {
        if (this.invoked) {
            return this.outDns1Server;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress getDns2Server() {
        if (this.invoked) {
            return this.outDns2Server;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress getNtpServer() {
        if (this.invoked) {
            return this.outNtpServer;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getDomainName() {
        if (this.invoked) {
            return this.outDomainName;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getBlockPoolId() {
        if (this.invoked) {
            return this.outBlockPoolId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getLeaseTime() {
        if (this.invoked) {
            return this.outLeaseTime;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getFlags() {
        if (this.invoked) {
            return this.outFlags;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getRangesSize() {
        if (this.invoked) {
            return this.outRangesSize;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress[] getFirstAddr() {
        if (this.invoked) {
            return this.outFirstAddr;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public InetAddress[] getLastAddr() {
        if (this.invoked) {
            return this.outLastAddr;
        }
        throw new IllegalStateException("Didn't invoke");
    }
}

