/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.urfa.functions;

import biz.netup.control.transport.urfa.UrfaException;
import biz.netup.control.transport.urfa.UrfaInvocation;
import biz.netup.control.transport.urfa.UrfaManager;

public class UrfaGetAccountinfo {
    private UrfaManager manager;
    private boolean invoked = false;
    private int inAccountId;
    private int outIsBlocked;
    private int outIsDealer;
    private double outVatRate;
    private double outSaleTaxRate;
    private double outCredit;
    private double outBalance;
    private int outIntStatus;
    private int outUnlimited;
    private int outAutoEnableInet;
    private String outExternalId;
    private String outIrdetoAccessCardNumber;
    private String outIrdetoSTBSerialNumber;

    public UrfaGetAccountinfo(UrfaManager urfaManager) {
        this.manager = urfaManager;
    }

    public void call() throws UrfaException {
        this.invoked = true;
        UrfaInvocation urfaInvocation = this.manager.startInvocation(86281);
        try {
            urfaInvocation.putInt(this.inAccountId);
            urfaInvocation.invoke();
            this.outIsBlocked = urfaInvocation.getInt();
            this.outVatRate = urfaInvocation.getDouble();
            this.outSaleTaxRate = urfaInvocation.getDouble();
            this.outCredit = urfaInvocation.getDouble();
            this.outBalance = urfaInvocation.getDouble();
            this.outIntStatus = urfaInvocation.getInt();
            this.outUnlimited = urfaInvocation.getInt();
            this.outAutoEnableInet = urfaInvocation.getInt();
            this.outExternalId = urfaInvocation.getString();
            this.outIrdetoAccessCardNumber = urfaInvocation.getString();
            this.outIrdetoSTBSerialNumber = urfaInvocation.getString();
        }
        finally {
            urfaInvocation.close();
        }
    }

    public void setAccountId(int n) {
        if (this.invoked) {
            throw new IllegalStateException("Already invoked");
        }
        this.inAccountId = n;
    }

    public int getIsBlocked() {
        if (this.invoked) {
            return this.outIsBlocked;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getVatRate() {
        if (this.invoked) {
            return this.outVatRate;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getSaleTaxRate() {
        if (this.invoked) {
            return this.outSaleTaxRate;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getCredit() {
        if (this.invoked) {
            return this.outCredit;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public double getBalance() {
        if (this.invoked) {
            return this.outBalance;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getIntStatus() {
        if (this.invoked) {
            return this.outIntStatus;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getUnlimited() {
        if (this.invoked) {
            return this.outUnlimited;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public int getAutoEnableInet() {
        if (this.invoked) {
            return this.outAutoEnableInet;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getExternalId() {
        if (this.invoked) {
            return this.outExternalId;
        }
        throw new IllegalStateException("Didn't invoke");
    }

    public String getIrdetoAccessCardNumber() {
        return this.outIrdetoAccessCardNumber;
    }

    public String getIrdetoSTBSerialNumber() {
        return this.outIrdetoSTBSerialNumber;
    }
}

