/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.ssl.impl;

import biz.netup.control.transport.ssl.SSLManager;
import biz.netup.control.transport.ssl.SSLManagerException;
import biz.netup.utmutils.control.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;

public class SSLManagerImpl
implements SSLManager {
    private SSLSocketFactory factory;
    private String[] protocols = new String[]{"TLSv1.2", "SSLv3"};
    private String[] cipherSuites = new String[]{"SSL_RSA_WITH_DES_CBC_SHA"};
    private X509Certificate certificate;
    private static final Logger LOG = Logger.getLogger(SSLManagerImpl.class);
    private static String keyStoreType = "PKCS12";
    private static char[] keyStorePassword = "ccseKSpwd".toCharArray();
    private static char[] keyStorePasswordCash = "ccseKSpwd".toCharArray();
    private static char[] rootKeyStorePassword = "ccseKSpwd".toCharArray();
    private static byte tmpb;
    private static String tmps;

    @Override
    public SSLSocket setSSL(Socket socket) throws SSLManagerException {
        if (this.factory == null) {
            IllegalStateException illegalStateException = new IllegalStateException("SSLManagerImpl is not initialized");
            LOG.error(illegalStateException);
            throw illegalStateException;
        }
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)this.factory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        }
        catch (IOException iOException) {
            LOG.debug(iOException);
            throw new SSLManagerException(iOException.getMessage(), iOException);
        }
        this.initSocket(sSLSocket);
        SSLSession sSLSession = sSLSocket.getSession();
        if (!sSLSession.isValid()) {
            SSLManagerException sSLManagerException = new SSLManagerException("Couldn't establish a valid SSL session");
            LOG.debug(sSLManagerException);
            throw sSLManagerException;
        }
        Certificate[] certificateArray = null;
        try {
            certificateArray = sSLSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            LOG.debug(sSLPeerUnverifiedException);
            throw new SSLManagerException(sSLPeerUnverifiedException.getMessage(), sSLPeerUnverifiedException);
        }
        if (certificateArray.length == 0) {
            SSLManagerException sSLManagerException = new SSLManagerException("No valid peer certificates found");
            LOG.debug(sSLManagerException);
            throw sSLManagerException;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            Serializable serializable;
            if (!(certificateArray[i] instanceof X509Certificate)) {
                serializable = new SSLManagerException(i + "'th peer certificate in chain is not a valid X.509 certificate");
                LOG.debug(serializable);
                throw serializable;
            }
            serializable = (X509Certificate)certificateArray[i];
            try {
                serializable.checkValidity();
                continue;
            }
            catch (CertificateException certificateException) {
                LOG.debug(certificateException);
                throw new SSLManagerException(certificateException.getMessage(), certificateException);
            }
        }
        return sSLSocket;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        LOG.debug("setting new cipher suites");
        this.cipherSuites = stringArray;
    }

    public void setEnabledProtocols(String[] stringArray) {
        LOG.debug("setting new protocols");
        this.protocols = stringArray;
    }

    public void init() throws GeneralSecurityException, IOException {
        if (Utils.isCashier()) {
            this.init(new ByteArrayInputStream(SSLManagerImpl.getData()), keyStorePasswordCash, keyStorePasswordCash, new ByteArrayInputStream(SSLManagerImpl.getDataRoot()), rootKeyStorePassword);
        } else {
            this.init(new ByteArrayInputStream(SSLManagerImpl.getData()), keyStorePassword, keyStorePassword, new ByteArrayInputStream(SSLManagerImpl.getDataRoot()), rootKeyStorePassword);
        }
    }

    public void init(InputStream inputStream, char[] cArray, char[] cArray2, InputStream inputStream2, char[] cArray3) throws GeneralSecurityException, IOException {
        LOG.debug("Starting initialization");
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
        LOG.debug("Loading private keystore");
        keyStore.load(inputStream, "ccseKSpwd".toCharArray());
        LOG.debug("Loading trusted keystore");
        keyStore2.load(inputStream2, "ccseKSpwd".toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        LOG.debug("Initializing KeyManager");
        keyManagerFactory.init(keyStore, "ccseKSpwd".toCharArray());
        LOG.debug("Initializing TrustManager");
        trustManagerFactory.init(keyStore2);
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
        LOG.debug("Initializing SSLContext");
        sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        this.factory = sSLContext.getSocketFactory();
        LOG.debug("Initialized");
    }

    protected void initSocket(SSLSocket sSLSocket) {
        sSLSocket.setEnabledProtocols(this.protocols);
        sSLSocket.setUseClientMode(true);
    }

    private static byte[] getData() {
        byte[] byArray = new byte[]{48, -126, 9, -31, 2, 1, 3, 48, -126, 9, -89, 6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 1, -96, -126, 9, -104, 4, -126, 9, -108, 48, -126, 9, -112, 48, -126, 4, 71, 6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 6, -96, -126, 4, 56, 48, -126, 4, 52, 2, 1, 0, 48, -126, 4, 45, 6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 1, 48, 28, 6, 10, 42, -122, 72, -122, -9, 13, 1, 12, 1, 6, 48, 14, 4, 8, 3, -89, -87, -63, 19, 95, 70, -14, 2, 2, 8, 0, -128, -126, 4, 0, 127, -91, -13, -47, -16, -15, 7, -93, -108, -89, -15, 114, -77, 111, 45, 57, 79, -69, -128, 99, 20, 75, 46, -107, 11, -93, -124, 50, 120, 46, -50, 120, -26, 102, 21, 103, 0, -25, -69, 4, 36, -85, 72, -76, 51, -103, 77, -109, -2, 103, 53, 74, -69, -76, 52, -116, -91, -112, 10, 4, -80, -48, -26, -26, -112, 72, 97, -99, -16, 91, -89, -16, 43, -106, 76, -42, 92, -10, 14, 121, 57, 115, 32, 88, 40, 55, 120, -112, -77, -124, 54, -69, -14, 19, -8, -34, -71, 118, -40, 99, 126, 34, -17, -87, -11, 11, -45, 42, -126, 15, 72, -69, 8, 98, -29, 101, -99, 99, -70, -77, -25, -26, 63, -84, 121, -74, 8, -4, -109, -107, -41, -52, -57, 101, -81, 74, -18, -39, -71, 116, -48, 8, 56, 40, 41, -99, -111, 23, -15, 51, 63, 117, -4, 24, 74, -93, -6, -95, -54, 37, -87, -118, -113, -42, 108, -103, -18, 91, 47, -81, -120, -70, -81, 83, -26, -55, -45, -88, 29, 60, 126, 37, -45, 67, 13, -72, -98, 62, -125, 25, -69, 69, 101, 91, -74, -90, 119, 45, 87, 64, -95, -90, 4, 28, 4, 40, 40, 39, 87, -76, -64, 35, 36, 36, 111, -31, 32, 78, -7, -2, 7, 105, 99, -121, -107, -49, 105, -31, 81, -19, 16, 100, 105, -23, 127, 106, 70, 106, 118, -76, 53, -74, -100, -31, -26, 1, -42, 100, -75, 50, 85, -104, -41, 97, 126, 60, -30, -94, 70, 105, -68, 38, 1, -88, 99, -117, 57, -44, -92, -26, -83, 13, 99, -126, -38, -20, -22, 91, 115, 67, -38, -111, 21, 10, -82, 36, 53, 118, -107, -28, 60, 97, 97, 12, -58, -28, 64, -39, 37, 99, -60, 90, 47, -70, 53, 63, 3, 42, 52, -114, -4, -19, -25, -126, 10, -55, -122, -21, 118, -77, 119, 23, 23, 1, 52, -108, 60, 100, 12, -62, 25, -97, -37, 117, -122, 74, 83, -13, -41, -7, 65, 57, 43, 56, -66, -121, 9, -9, -126, -36, 68, 107, -29, 61, -127, -40, -40, 121, -79, 73, -14, 46, -42, 105, -74, -88, -76, 40, 78, -69, -68, -69, 88, -29, 96, 19, 17, 38, 43, -14, -33, -27, 114, 115, -52, -103, -30, 124, 105, 109, -127, 10, -8, -65, -106, 41, -85, -107, 106, 8, -92, -14, 120, 26, 21, 43, 7, 58, -86, -82, -78, -46, -45, -10, 45, -116, 99, -56, -115, -89, -63, -127, -78, 27, 114, -15, -16, -79, 61, -45, 23, 32, -3, -28, -74, -18, -57, 66, -105, -85, 14, 93, 101, -1, -5, -44, -83, -77, -19, 80, -105, -14, -75, -81, 127, 42, 77, 36, -6, 122, -50, 14, -110, -105, -57, 40, -14, -58, -4, -12, -123, 51, 36, -60, 15, -58, -16, -46, -90, -80, -64, -113, -56, -85, -119, 118, -60, 81, -54, 5, -40, 61, -25, 2, 100, -89, 45, 90, -11, -70, 51, 104, -59, -119, -31, 6, -71, -54, 95, 70, 52, -90, 64, 52, 105, -60, -75, -3, 58, -70, 47, 102, -52, -42, 122, 117, -45, 96, 32, 48, 18, 53, 96, 50, 4, -26, 86, 0, 44, -61, -66, 64, 72, -106, 62, 46, 0, -9, -50, -23, -75, -21, 14, 24, -28, -45, -112, 27, -96, 35, 4, -34, 48, -109, -44, -99, 17, 14, -65, 101, 119, 20, 6, -42, -80, -93, 97, 15, 44, -31, -45, 14, -119, 93, -106, -49, 14, -35, -126, 38, 32, -120, 19, 101, 0, -42, 82, -13, 12, 36, 43, 71, -113, 12, -15, 55, 32, -7, -33, -44, -107, -42, -26, 70, 21, -46, -81, 76, -105, -91, 82, -98, 124, -12, 127, -51, 54, -21, -39, 79, 52, -17, 41, -5, 18, -108, 52, 13, -64, -34, -23, -29, 94, -92, 86, 75, -111, -15, 15, 83, -101, 112, 47, 125, 82, 35, 10, 17, 78, -51, -75, -54, 44, 105, -71, -32, -104, 98, 84, 64, -58, 127, 56, -73, 77, -46, 21, -64, -47, -100, -17, -66, -91, 23, 87, -109, 51, -21, -114, 23, -65, 122, 118, -123, 28, -18, -87, 75, -83, -68, -58, 125, 97, 6, -20, 103, -5, -75, -60, 70, 68, -89, -53, -38, -82, 110, 81, 24, 11, -128, -8, 58, -71, 24, -91, 68, 107, 56, -28, -33, -98, -84, 70, -65, 98, -94, 4, 58, 75, 15, -96, -13, 123, -40, -108, -55, -61, 119, -21, 47, 121, -53, -75, 19, -22, 121, 64, 51, 33, 43, 126, -86, 95, 126, -37, -5, -81, 79, 62, -68, 17, 78, -3, -19, 1, 5, 89, -4, 40, 111, 75, -39, 49, -126, 120, -28, -33, -32, 95, -101, -96, -27, 8, 34, 106, -95, 58, 95, 64, 78, 106, 84, 31, 118, 3, -3, -100, -91, 13, -72, 55, -54, 55, -45, 105, -5, -1, 36, -41, -101, -51, 125, -64, -126, -31, 62, -101, 15, -41, -95, -2, -29, 61, -100, 29, -54, 98, 46, 92, -121, -50, 7, 50, -122, 67, -77, -79, -27, 23, 49, -3, 22, 94, -89, 49, 31, 96, -6, 15, 127, 3, 86, 87, -39, 9, -118, 41, 68, -125, 107, 34, 79, 94, -121, 90, 101, 14, -58, 92, -99, -85, 45, 125, 109, -99, -82, -124, -61, -69, 122, -105, 120, -14, -92, 1, 69, 37, -109, 120, 77, -83, 104, 66, 36, 1, -51, -59, 75, -122, -48, 89, 89, -4, 121, -32, -39, 94, 124, 26, -118, -113, -84, -69, -122, -35, -39, -26, 100, 46, -79, -50, -40, 91, -38, -122, -119, -73, -103, 57, -19, 71, 5, -86, -80, 123, -72, 24, -69, 2, 97, 94, -15, -14, -37, 5, 19, 47, -14, 80, -14, 109, -104, -40, 4, 69, 39, 119, -7, 33, 22, 93, 98, -98, -81, 52, -30, -62, 120, 104, 21, 63, -52, -34, -56, 123, -27, 62, 40, -112, 41, 4, 60, 16, 93, 76, -59, -60, 119, -14, -103, -3, -46, 103, 103, -24, -111, -121, 17, 92, -32, -36, -70, -75, 27, 88, -86, 48, 32, 82, 1, 42, 95, 70, -4, 48, -126, 5, 65, 6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 1, -96, -126, 5, 50, 4, -126, 5, 46, 48, -126, 5, 42, 48, -126, 5, 38, 6, 11, 42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 2, -96, -126, 4, -18, 48, -126, 4, -22, 48, 28, 6, 10, 42, -122, 72, -122, -9, 13, 1, 12, 1, 3, 48, 14, 4, 8, 5, 7, 55, -37, -97, 98, 104, 123, 2, 2, 8, 0, 4, -126, 4, -56, -97, -88, 67, -7, -24, 49, -5, -86, -32, -23, -101, 125, 44, 31, 40, 66, -3, -54, 45, 87, 118, 100, -94, -1, 108, 45, -7, 23, -95, 114, -40, -57, -38, -25, -37, 68, -35, 25, 96, -92, 16, -34, 115, 106, 9, -45, -118, 96, 100, 22, -98, -31, 63, 80, -16, 107, 21, 11, -52, 2, -127, -48, -71, -50, -99, -101, -3, -74, 63, -66, 72, 125, 45, 33, 91, -19, -102, 38, -74, 85, 108, -97, 90, -65, 76, -41, 46, 118, -36, -108, 84, -9, 50, 21, -122, 121, -15, 123, 36, 102, -59, 20, 63, 20, 49, -127, 52, -104, 83, 23, 33, 89, 35, -12, -51, 63, 84, 76, 34, 83, 29, -67, 4, -81, -64, -4, -42, 80, -22, 27, 40, 103, 115, -49, 63, -84, -114, 122, -6, 13, 26, -31, 69, 18, -125, 32, 18, 100, -119, -44, 39, 15, 20, -86, -95, 92, 4, 114, 20, -67, 59, -26, -57, -70, -13, 55, -48, 119, 95, -12, 38, -83, 31, -118, 108, -94, 77, -25, 13, -71, -30, -69, -78, -4, -65, -51, -106, 63, -92, 116, 119, -45, 109, -13, -91, -59, 104, -13, -99, -53, 63, 52, 8, 83, 12, -72, -116, -35, -128, 2, 103, -28, -58, -42, 39, 1, -95, -23, -102, -3, 46, 109, 83, -83, -93, 29, 65, 57, -110, 75, -2, 86, 71, -94, 99, -111, -63, -120, 69, 44, -25, 121, 33, -3, -23, 55, 19, -21, 103, 28, 98, -59, 17, 123, 89, 10, 30, -72, -19, 111, -47, 71, 34, 85, 5, -44, 21, -13, 51, -96, 73, 126, -101, -22, -121, -62, 98, -112, 60, 69, 113, 117, -20, 73, -26, 81, 118, -77, 61, -42, 38, 108, 53, -48, -66, -46, -18, -40, -86, -113, 107, 100, 23, -21, 41, -30, -96, 51, 28, -42, 10, -101, -100, 71, -127, -89, 116, 40, 24, 73, -84, 122, -91, 80, -24, -121, 31, 59, 113, -94, -40, -40, 126, 20, -48, 14, -80, 77, 61, -88, 68, 111, 70, 18, 93, 42, 49, -52, 67, -3, 84, 53, -28, -49, -39, -60, -54, 82, 117, 25, -84, -3, 90, 22, 52, -78, -84, 72, 31, -85, 123, -61, 66, 113, -50, 3, -46, -73, -41, 78, -49, 6, 119, -102, 71, -15, 3, -117, -63, 121, 74, -120, -87, 10, -96, -48, -80, 46, -23, 87, -69, -31, 20, 54, -18, -33, -110, -11, 89, 44, -18, 121, -56, 54, -68, 0, -73, -64, -23, 31, 108, -125, 69, -126, -123, 12, 24, 107, -19, 91, 121, -59, -79, -63, 44, 6, -105, 59, 102, -105, 32, -22, 28, -88, -65, -62, -122, -62, -35, 10, -115, -2, -27, -38, 69, 45, -5, -70, -110, 31, 112, -69, 56, -105, 108, 113, 76, -51, 114, 4, 43, 15, 119, -124, 2, -29, -98, -16, 94, 60, 5, 6, 82, -105, 11, -62, 32, 25, 103, -14, 86, -46, 101, 72, -60, 111, -49, -119, -108, -83, 52, -106, 105, -8, -118, 6, -67, -12, -113, -13, -74, -6, -96, 32, -12, -95, 3, 37, -51, 43, 113, -50, 20, 125, 67, 6, -78, 44, -34, -114, 5, 125, 0, 116, -16, 47, -46, -78, -42, -116, -107, -5, -109, -97, -62, -128, -122, -66, 116, -104, 118, 106, 98, 46, -58, 27, 5, 117, -97, -4, 80, -78, -8, 41, -32, 68, -63, -109, -21, -74, -128, 94, -114, -117, 75, 74, 54, 92, -93, -128, 99, 24, 96, 10, -116, 110, -38, 3, 1, 103, -99, -65, 36, -122, -84, 80, 81, 103, 106, -98, 24, 11, 35, 8, 44, 0, 42, 2, -23, 34, -50, -91, -74, -92, -120, 115, -123, -34, -120, 24, 19, 16, 123, 79, -67, 70, -13, -73, 110, 61, -62, 39, -4, -19, 54, -118, -110, -113, 85, -47, 20, 6, -30, 53, 86, 126, -40, 127, 85, -42, -78, 13, -29, -16, 83, 76, 24, 12, 81, 112, -45, 68, 57, -86, -82, -72, -5, -107, -25, 58, 42, -12, -64, 87, -117, -35, -42, 1, -29, -35, -28, 59, 94, -120, -102, 109, -65, -91, -37, -1, -19, 123, 25, 0, 2, 95, 84, 20, 106, -109, 90, -50, -68, 50, 63, 3, 108, -68, -117, 126, 2, 94, -128, -86, 82, -2, 105, 104, -74, -36, -31, 46, 32, 63, -95, 7, 62, 99, 39, 26, -28, 68, 114, 125, -51, 12, -96, 98, -58, -61, -75, -23, 36, -85, -66, 104, 106, 125, 38, 99, -4, 5, 110, 100, -51, 4, -120, 111, 15, 65, -61, 48, -75, -12, -87, -52, 114, 127, 41, -3, 48, 62, 52, 56, -115, -60, 22, 75, -115, -47, -63, -127, 63, -112, -12, -23, 46, 47, -22, -34, 1, 54, 64, -82, 87, 14, 69, -127, 115, -123, 84, -114, -123, 70, -119, 125, 72, 63, -121, 97, -8, -111, -79, -65, 98, -4, 84, 105, 86, -13, 79, 78, -91, 10, -47, -53, 92, -40, -10, 123, 93, -14, 81, -32, -50, 33, 18, -117, 28, 17, -68, 104, 80, -54, 54, 102, -65, 71, 75, -81, 125, 62, -32, -96, -42, 48, 71, 61, 56, -107, -123, -12, -73, -110, -16, -36, -25, -20, -111, -91, 75, -79, -74, 47, -78, 25, 111, 119, 3, -52, -33, -86, 104, -117, 65, 95, 100, -101, -45, 54, -123, -98, -112, -48, -44, -4, -27, -73, -43, 104, 103, 59, -11, 124, -60, -101, -37, -76, -108, -10, 8, 20, -123, -13, -35, 97, -115, -112, 18, -109, 69, 20, 26, 121, -116, 71, 28, -8, 28, 43, 39, 96, -2, 68, -5, 119, 36, -69, -45, -32, 89, -99, 91, -2, -34, 74, -52, 70, 112, -23, -18, 66, -12, -92, -104, 47, 4, -61, 18, -9, 64, 28, -45, -14, -89, -9, 92, -73, 77, 103, 80, 108, -24, -104, -117, -29, 46, 53, 95, -8, -51, -94, -102, -110, 68, 24, 71, 60, 72, 120, 56, -3, -85, 122, 22, -108, -65, 110, 39, -26, 22, -6, -65, 8, 76, 57, -39, 13, 24, 12, 88, -102, -52, -100, 92, -124, 76, -101, -47, 120, -1, 44, 6, -48, -126, 127, -77, 38, -110, 41, 44, 54, 62, 66, -21, 56, 124, -58, -105, -85, 86, 42, -13, 84, 116, 22, -35, -118, -4, 79, -23, -101, -19, 47, -118, -82, -62, 87, -77, -101, -57, -3, 10, 65, -11, -22, -67, -90, 30, -48, 105, 89, -41, 76, 33, 26, 102, -126, 99, -48, 109, 72, -48, -69, 2, -106, -9, 32, 30, -1, -39, 92, 108, 126, -2, -6, 100, -15, -107, 126, 121, 38, -2, 44, 125, -21, 38, 6, 11, -51, 5, 30, -49, -18, -2, 23, -36, 107, -84, 28, 120, 75, -41, 123, 60, -105, 78, -51, 83, -76, -79, 73, -91, -93, 67, 32, 41, -105, 123, -13, -119, -27, 86, 46, -99, -18, -46, -35, 51, 13, 3, 103, 52, 39, 93, 120, 44, 55, -46, -69, 31, 58, -121, 10, -76, 104, -70, 124, 62, -86, -47, -14, 62, -104, -91, -31, 97, -52, 21, 29, -95, -104, -9, 93, 100, -118, -33, -22, -39, -54, 18, 49, -51, -102, -72, 57, -67, -96, -111, -5, 7, 33, 113, -54, -11, -2, -15, -21, -76, 70, 54, -32, 79, -37, 53, 2, 55, 91, -47, 103, 102, -14, 71, -30, 49, 37, 48, 35, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 21, 49, 22, 4, 20, 1, 50, -6, 66, -55, 71, 50, 52, 23, 103, 77, 100, 109, 66, 42, -55, 2, -17, -81, 98, 48, 49, 48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20, -27, 99, 11, 9, -65, 44, -26, -16, -126, 11, -70, -98, -58, 60, 56, -94, -103, -98, 29, -85, 4, 8, 11, 121, 68, -49, -103, 109, 90, 32, 2, 2, 8, 0};
        return byArray;
    }

    private static byte[] getDataRoot() {
        byte[] byArray = new byte[]{48, -126, 10, 57, 2, 1, 3, 48, -126, 9, -1, 6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 1, -96, -126, 9, -16, 4, -126, 9, -20, 48, -126, 9, -24, 48, -126, 4, -97, 6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 6, -96, -126, 4, -112, 48, -126, 4, -116, 2, 1, 0, 48, -126, 4, -123, 6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 1, 48, 28, 6, 10, 42, -122, 72, -122, -9, 13, 1, 12, 1, 6, 48, 14, 4, 8, 123, 36, -90, -93, 84, 76, 7, -128, 2, 2, 8, 0, -128, -126, 4, 88, -20, 114, 60, -74, -60, -37, 67, -41, 33, -22, -110, -91, -81, 115, 94, 101, -72, 124, -106, 8, -11, -74, -78, 110, 68, -32, -117, -48, -88, -100, -125, 117, 104, -63, -49, 83, 95, -83, -110, 17, -80, -26, -60, 29, -3, -49, -93, 5, 31, 42, 59, -72, -55, 114, -87, 11, -48, -59, 101, -52, 41, -7, 88, -32, 85, 6, 105, 62, -68, 76, 52, 94, -41, 98, 123, -110, -127, 71, -59, 53, -93, -18, -75, 29, 71, 47, 11, 24, 69, -100, -108, 16, -54, 114, -29, 79, 79, -68, 69, 94, -95, -101, -92, -109, -23, -13, -1, 7, 63, -51, 47, -62, 74, -82, -81, 57, -22, 65, -73, -45, 6, 124, -69, 89, -125, -31, 16, 79, -119, 102, 39, 34, 114, -88, -85, -28, 94, 45, 14, -78, -57, 121, 99, 33, -43, -27, -105, 9, 108, 83, -80, -92, -122, -72, 33, -94, -87, -85, 49, 12, -10, 116, -90, 119, 13, -31, 104, -47, 62, 84, 127, 98, -7, 72, -104, -15, 39, -31, 78, 32, -46, 67, -30, -2, -103, 98, -96, -117, 101, 14, 124, 35, -115, 104, -77, 94, -32, 49, 11, 94, 116, 120, -44, -15, -32, -8, -103, 97, 115, -78, -93, 59, -112, -69, -6, 64, -122, -24, -62, 95, 110, 49, 4, 90, -2, 9, 60, 76, 37, 113, 2, 93, -29, -38, 125, -62, 86, 71, 31, 85, -68, -102, 60, -70, 54, 88, -82, 77, -26, 110, -65, -33, -114, -98, -26, -121, -120, 40, 1, 36, 127, -100, -65, 122, -22, -38, -87, 46, -15, -23, -5, -107, -34, 93, -99, -97, 121, 53, -81, -93, -63, -85, -7, 47, 49, 39, -32, -99, 116, 86, 28, -22, -1, 25, 85, -30, -103, 55, -120, 100, -86, 20, 13, 46, -16, 79, -43, 102, -39, 71, 1, 111, -104, 46, 70, -113, -127, -50, -116, 40, -108, 103, 100, -8, -20, -65, -73, 2, -118, 117, -17, 13, -48, -63, -48, 60, -40, 13, -13, -53, 101, -7, -4, -24, 16, 52, -80, -12, 29, 67, -59, -97, -74, 105, -31, -75, -88, -119, 91, 20, 111, -74, -121, -78, -121, 41, 1, 88, 75, 75, 72, -75, -94, -11, -43, 10, -66, -117, 44, 105, 74, -77, -13, -39, -22, -125, -75, 7, 4, 43, 66, 115, -6, -70, -53, 58, 19, 67, -54, -21, -90, 61, -122, -116, 49, -122, -87, 81, 63, 67, -95, -62, 85, -40, -80, -29, 18, -69, -91, -19, 121, -26, -110, -39, -50, 87, 103, -103, -31, -1, 50, 78, 120, 60, 12, -121, 68, 30, 95, 8, -47, -122, 33, -68, 106, -29, -42, 87, -26, -63, -62, 35, -52, -15, 61, 24, -77, -57, 118, 58, -128, -35, 39, -72, -54, 76, -27, 71, -117, 5, -56, 89, -50, 68, -98, -50, -53, -84, 53, 95, -91, -116, 70, -74, -29, 127, 30, -95, 105, 42, -86, 71, 126, -17, 12, -108, 49, -96, 84, -62, -19, 123, -121, -13, -3, -40, -119, -33, 56, -43, -113, 7, -19, 52, 117, -77, -69, 18, -66, -95, 38, -90, 42, 112, -100, 84, 121, 57, 14, 20, 42, 107, 124, 80, -66, 98, -32, 68, 71, 79, 40, -74, 61, -92, -85, 72, -17, -117, 16, -84, 95, 29, -16, 88, -113, -10, -17, 110, -100, 1, -47, 79, -40, 5, -103, -94, 10, -32, 127, -106, 109, 23, 62, 50, 67, 24, 4, -81, -93, -69, 58, 37, 19, -109, 14, -56, 111, 51, -74, 44, -71, 75, 75, -63, -41, -55, 69, -34, 18, 19, -100, -72, -46, 106, -121, 91, 6, -78, -31, -63, -67, -117, -71, -40, -120, -75, 56, -16, 115, 101, 42, 60, 9, -31, 92, -43, -96, -97, 126, 107, 91, -19, 48, 20, 58, 78, 59, 52, -114, -75, 85, -93, 45, 28, 10, 31, 45, -55, -61, -114, -42, -39, 0, 50, -51, 92, -90, -35, 0, 127, -108, 115, -108, -3, 54, -111, 113, -76, -45, 85, 75, -35, -118, -44, 9, 98, 24, 27, 106, -43, -38, -46, -97, 55, 119, 36, -18, 97, -11, 14, 12, 89, -78, -5, 83, -12, 0, 66, 120, 11, 45, 29, -86, 67, 57, 80, 70, -59, -75, -113, 48, 31, 55, 39, -15, 13, -99, -68, 73, -8, 92, 15, -6, 98, -86, -52, -65, -45, -67, -126, 102, 56, 37, -85, 0, 0, 96, -44, -103, 53, 66, -60, 44, 64, -36, 24, -76, 66, 50, 60, 55, 69, -51, -70, -50, -20, 19, -13, -73, -88, -120, 67, 27, 34, 42, -68, 63, -122, -65, -118, 88, -86, -86, 103, 112, -10, 62, 104, 66, -33, -55, -16, -16, 109, 58, -108, 123, -79, -21, -32, 72, -94, -66, -82, -108, -78, 102, -114, 74, 102, 60, -68, -90, 41, -105, 57, -116, 45, 20, 56, 51, -64, 54, 120, -9, -114, 6, -31, -61, 30, 29, -53, -70, -5, -119, 125, 101, -59, -82, -81, -125, -23, 34, 40, -86, 55, -57, 48, -68, 52, 64, -115, 24, 85, 54, 12, -51, 39, -92, -88, 72, 52, -65, -9, 55, 114, 88, -71, -49, 84, -120, -21, -34, -92, 79, -46, 45, -104, -3, 5, -15, 73, -19, 40, 124, -123, -95, -91, -25, 123, 82, -125, -32, -56, -52, -114, 36, 52, 58, 82, 37, 48, -32, -79, -72, -123, -100, 0, 10, 30, 122, 59, 108, 105, -49, 8, 110, 110, 115, 115, -104, -105, 59, 69, 32, 27, 27, -49, -12, -126, 15, -114, -57, -58, -107, 68, 79, -31, 2, 72, 95, -76, -107, 25, -6, 27, -116, -13, -39, 66, 59, 47, -103, 74, -80, 2, 102, -62, 60, -1, -33, -83, 97, 120, 42, 50, -98, -40, 3, -109, 13, -96, -45, -117, -53, 127, 55, 62, -10, -95, -85, 68, -28, -15, -109, 28, -76, 36, -52, -109, -88, -59, -36, 34, -81, 16, -16, -36, -90, 28, -124, 86, 123, -48, 19, -118, -124, -16, 0, -71, -128, 105, -107, -99, 12, -73, -49, -26, -94, -36, 116, -124, 78, -20, 99, -76, -88, -31, 62, -125, 92, -104, 67, -89, -110, 101, 101, -45, -37, 8, -57, 54, 84, -41, -78, -93, -90, 92, 53, -8, -100, 81, 102, -73, 17, -27, -26, -86, -55, 21, 81, -14, 71, 81, -119, -42, 47, 61, -21, 40, -32, 123, 70, 88, -48, 95, 99, 114, 115, -95, -8, -33, 73, -92, -72, -123, -126, 111, -34, -51, -21, 35, 31, -114, -21, 42, -77, 20, 77, -109, 80, 91, 52, 25, 50, 63, 34, 50, 7, 108, -55, 123, -67, 88, -83, 72, -5, -34, 68, 37, -19, -17, 48, -126, 5, 65, 6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 1, -96, -126, 5, 50, 4, -126, 5, 46, 48, -126, 5, 42, 48, -126, 5, 38, 6, 11, 42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 2, -96, -126, 4, -18, 48, -126, 4, -22, 48, 28, 6, 10, 42, -122, 72, -122, -9, 13, 1, 12, 1, 3, 48, 14, 4, 8, -92, 28, -34, 79, -7, -120, -106, -93, 2, 2, 8, 0, 4, -126, 4, -56, 27, 116, -7, 93, 5, 23, 51, 54, -70, -85, -52, -111, 32, 19, -54, 122, 21, -5, 45, 11, -60, -61, 34, 126, -48, 13, 90, 75, 12, 120, 103, -69, 17, 121, -78, 116, 99, -17, 21, 69, -48, 36, 88, 78, -50, -69, 51, 28, -32, -56, -22, 86, 82, -65, 84, 0, -25, -71, 124, -117, -4, 6, -103, -112, 2, 98, 69, 67, -92, 47, -71, -18, -76, -36, 81, -30, -39, 83, -43, 29, 101, 114, 120, -56, 5, 16, -93, -125, -31, 75, 100, 104, 45, 62, -94, 50, -102, -124, 19, -47, -124, 12, -103, 95, -73, 120, 75, 31, -107, -124, -40, -77, 51, -51, 121, 121, -43, -33, -7, -105, 21, 82, -119, -121, -42, -3, 71, -101, 49, 11, 0, -106, 49, -110, -98, 41, 35, -117, 77, 36, -30, 95, -43, 29, -97, 112, 90, 26, -88, -43, 62, 18, -101, -67, 54, 3, -77, 49, 87, 64, -117, -99, -112, -106, -124, -37, 18, -48, 101, -76, -8, 2, 6, -80, 53, 100, -114, -109, 72, -35, 111, 58, -51, -80, -45, -11, -33, 86, 119, -99, -103, -97, 99, 9, -53, 27, 71, 105, -11, 90, -84, -38, -95, -74, 108, 74, 81, 123, -98, -85, 12, 122, -60, -94, 56, -100, -72, 125, 70, -48, 49, -110, -34, -36, -17, -69, 45, -18, -55, -64, 39, -55, -79, 5, -102, 66, -41, -25, 68, -18, 2, -39, 27, 21, 1, 103, 18, 14, -101, -16, -5, 46, -111, -106, 35, 54, -20, -28, -83, -10, -27, -40, -24, 31, 45, 16, 36, -23, -24, 67, -114, 63, 13, 85, -17, -91, 9, -68, 52, 39, -40, -100, -74, -70, -33, -30, 125, 104, 39, 26, 3, 62, 48, -1, -34, 122, 122, -107, 43, 47, 33, -12, 80, 48, -83, 45, -96, -99, -121, 127, -99, -69, 56, 106, 39, 6, -19, -122, -9, 2, -64, 56, 44, 127, 48, 60, 95, -108, 122, -37, -42, -41, -104, 76, 104, -117, 118, 4, -46, 116, 111, -123, -118, 94, 111, 58, -113, 72, -4, -103, 71, 69, 93, -28, -35, 117, -19, -93, -83, 53, 23, 65, 50, 58, 29, -49, -121, -51, 28, -66, -37, -56, 111, -1, -88, 119, 10, 118, 111, -29, -59, -60, 37, 38, -18, -117, -84, 24, -68, -16, 47, -73, 90, 63, 112, -70, 72, -125, -78, 99, 9, 92, 123, -127, 103, 47, 101, -16, 48, 22, 29, 78, -97, -70, 77, -54, 67, 90, -47, 7, -28, 95, -3, 11, 40, 49, -24, -66, -24, 19, 124, 72, -101, -107, 19, -82, 9, -92, -55, -40, -16, 58, 68, -90, 32, -35, 8, 17, 46, 1, 66, 26, 113, -56, 111, 76, -59, -85, 75, -84, -4, 118, -78, -18, 102, 94, -127, -22, -109, -84, -57, 37, -80, 94, 71, -8, -57, -8, -75, -25, -18, -66, -73, 112, 13, -80, -113, -5, 73, -83, -32, 54, -95, 14, -45, -38, 102, -102, 70, -55, 89, 64, 6, 72, 70, -62, 34, 103, -112, 52, -79, -63, -50, -53, 15, -65, -122, 119, -79, -24, -119, -53, 76, 119, -57, -107, -62, 47, -87, -32, 59, 22, -39, -81, 0, -85, -89, -49, 28, -108, 56, 121, 109, -69, 43, 28, 127, -36, 88, -67, -114, 105, 72, -95, 23, 88, 22, 57, -123, -111, 26, 56, 69, -41, -74, -93, 58, 31, -116, 65, -58, 93, 4, 95, -51, 108, -27, 35, -19, 83, -123, -72, -52, 49, -51, 4, -67, 46, 96, -61, 47, -64, 121, -128, -81, 17, -69, 12, 90, 41, -11, -81, -56, -47, 0, -40, -89, 64, -125, -84, 121, 4, 8, 52, 125, -36, 97, -122, -3, -19, -56, 15, 27, -127, 101, 40, 113, -60, -8, 105, 6, 108, -104, -24, -127, -90, 38, 61, 78, -67, -124, -26, 118, 81, -39, 126, 33, 121, -87, 6, -128, 2, -1, -83, -29, 27, -75, 28, 31, 74, 15, -15, 45, -102, 50, -85, 70, -105, -49, 19, -30, 1, 71, -27, 99, -14, 73, 7, 32, -18, 58, -2, 70, 116, -27, -127, -83, -28, 82, -39, -91, -93, 100, 60, -4, 109, 105, 86, -108, -95, -18, 12, 16, 2, -55, -48, -17, -34, 99, 16, 63, -73, 113, -9, -87, 11, -97, 29, -34, 64, -90, -81, -25, 74, 64, -6, -49, -92, 20, -107, 13, 40, 75, 73, -85, -37, -10, -71, 115, -124, -84, -15, 84, -93, -71, -26, -99, 89, 118, 94, 84, 58, 53, -123, -108, -55, 61, -112, 59, -62, -17, 103, -87, 85, -87, -22, 68, 68, 42, 71, 64, -52, 104, 15, -15, 126, 11, 41, 8, 29, -34, 61, 100, -36, -42, -76, -99, 32, 105, -63, 89, 57, 43, 70, 18, 42, -38, -84, -29, 30, -50, 13, -65, 29, -78, 125, 48, -43, 111, -39, -67, 53, -110, -37, 57, -9, -43, 17, 92, 99, -59, -106, 97, 59, 23, 17, 55, 11, 6, -28, 27, 11, 24, -123, -77, -61, -53, -23, -1, 126, 68, -126, -20, 79, 57, -60, -59, 104, 42, -66, 100, -127, 123, -75, -19, 118, -60, 125, 74, 91, 110, 84, 62, -100, 89, 88, 27, 20, -96, 96, 6, -21, 86, 44, 66, -37, -41, -57, -17, -4, 99, -113, -73, 120, -79, 102, 41, 63, 5, 5, 47, -101, -120, -126, -73, -33, 77, -63, 33, -95, -107, 1, -92, 30, 17, 38, 40, 90, -59, 66, 48, 19, -54, -3, -111, 25, -120, -49, 86, -58, -71, 55, 49, 112, 78, 14, 41, -18, 37, -127, 34, 48, 113, -20, -121, -17, 33, 6, -110, -97, 24, 63, 72, -30, -79, 61, 67, -24, 99, -79, 109, -27, 69, -22, 112, -11, -65, -47, -103, 77, -91, -88, -40, -92, 10, -88, -88, 32, 91, -66, -1, -66, 49, 61, 23, 99, 91, 64, -65, 64, 38, -68, -1, -95, -65, 76, 27, -3, -117, -78, 58, 77, 115, -14, -103, -44, 52, -102, -72, -81, -61, 105, -78, 103, 120, 31, 48, 99, 55, -121, 32, -74, -107, 19, -94, 113, -11, -34, -123, -46, -42, -57, -49, -51, 46, -73, -111, -87, 13, -55, -81, -99, 100, -11, 22, -50, -51, 117, -26, 18, -81, 83, -39, -128, 65, -40, -61, 123, 17, -6, -3, 69, 40, -82, -125, -9, 110, -70, -105, -29, 57, -114, 41, 110, -54, -5, -115, 15, -50, -73, 86, 115, -38, 10, -19, 59, -113, 22, -76, 68, 105, 100, -124, 81, -23, -66, -121, -45, 113, -90, -121, 9, 15, -93, 104, -71, 123, -111, 49, 48, -22, -123, 28, 42, -50, 66, -3, 121, 4, 62, -49, 28, 26, -45, 36, 22, 72, 50, 19, -104, 47, -32, -3, 111, -64, -25, -123, -13, 117, 51, -103, 83, 86, 63, 90, -86, -93, 70, 25, 122, 79, 106, -113, -32, 4, 6, -12, -89, -25, -114, -113, -8, -45, -88, -121, 18, -111, -122, 67, 11, -1, -108, -67, 41, -2, 75, 108, -7, -70, 53, 69, -51, -122, -64, -56, -94, 77, -62, -32, 72, 32, -113, 6, 18, 12, 66, -104, -35, -58, -15, 43, 72, -40, 58, 80, -43, 81, -66, -74, -77, 68, 63, 3, 57, 50, 47, 106, 53, 50, 42, -93, -90, 10, 17, -89, -16, 16, -76, -23, 24, 76, 88, 31, -113, 49, 37, 48, 35, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 21, 49, 22, 4, 20, 14, 110, 127, 27, 122, -127, 24, -116, -100, -86, 2, 59, -46, 62, -77, -20, -27, -26, -31, -18, 48, 49, 48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20, -100, 0, -90, -70, -96, -52, 104, 79, -109, 55, 88, 48, -2, 85, 122, -19, 96, -33, 105, -82, 4, 8, -90, -1, -20, -6, -118, 82, -23, 94, 2, 2, 8, 0};
        return byArray;
    }

    static {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(SSLManagerImpl.class.getName());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (resourceBundle != null) {
            try {
                keyStorePassword = resourceBundle.getString("keyStorePassword").toCharArray();
            }
            catch (Throwable throwable) {
                LOG.debug("Property file does not specify the <keyStorePassword>");
            }
            try {
                keyStorePasswordCash = resourceBundle.getString("keyStorePasswordCash").toCharArray();
            }
            catch (Throwable throwable) {
                LOG.debug("Property file does not specify the <keyStorePasswordCash>");
            }
            try {
                keyStoreType = resourceBundle.getString("keyStoreType");
            }
            catch (Throwable throwable) {
                LOG.debug("Property file does not specify the <keyStoreType");
            }
        }
    }
}

