/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.transport.impl;

import biz.netup.control.transport.Connection;
import biz.netup.control.transport.ConnectionResetListener;
import biz.netup.control.transport.impl.Handshake;
import biz.netup.control.transport.ssl.SSLManager;
import biz.netup.control.transport.ssl.SSLManagerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import org.apache.log4j.Logger;

public class ConnectionImpl
implements Connection {
    private String host = null;
    private int port = 11760;
    private ConnectionResetListener connectionResetListener = null;
    private SSLManager sslManager = null;
    private Socket socket = null;
    private InputStreamDecorator inputStreamDecorator = new InputStreamDecorator();
    private OutputStreamDecorator outputStreamDecorator = new OutputStreamDecorator();
    private Handshake handshake = new Handshake();
    private static final Logger LOG = Logger.getLogger(ConnectionImpl.class);

    @Override
    public void setHost(String string) {
        LOG.debug("Host = " + string);
        if (string == null) {
            throw new IllegalArgumentException("host");
        }
        this.host = string;
    }

    @Override
    public void setPort(int n) {
        LOG.debug("Port = " + n);
        this.port = n;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setConnectionResetListener(ConnectionResetListener connectionResetListener) {
        LOG.debug("New ConnectionResetListener");
        this.connectionResetListener = connectionResetListener;
    }

    @Override
    public void setSSLManager(SSLManager sSLManager) {
        this.sslManager = sSLManager;
    }

    @Override
    public synchronized void connect() throws IOException {
        Socket socket;
        LOG.info("connect()");
        if (this.host == null) {
            throw new IllegalStateException("host is not initialized");
        }
        this.disconnect();
        try {
            socket = SocketFactory.getDefault().createSocket(this.host, this.port);
            LOG.debug("Connected to " + this.host + ":" + this.port);
            LOG.debug("Starting handshake");
            this.handshake.run(socket);
            LOG.debug("Handshake complete");
            if (this.sslManager == null) {
                throw new IllegalStateException("SslManager is not initialized");
            }
            socket = this.sslManager.setSSL(socket);
        }
        catch (IOException iOException) {
            LOG.error(iOException);
            this.disconnect();
            throw iOException;
        }
        catch (SSLManagerException sSLManagerException) {
            LOG.error(sSLManagerException);
            this.disconnect();
            throw new SSLException(sSLManagerException.toString(), sSLManagerException);
        }
        LOG.debug("Handhake finished");
        this.socket = socket;
        this.inputStreamDecorator.unlock();
    }

    @Override
    public synchronized void disconnect() throws IOException {
        LOG.debug("disconnect()");
        this.inputStreamDecorator.lock();
        if (this.isConnected()) {
            this.socket.close();
            this.socket = null;
            LOG.debug("Disconnected from " + this.host + ":" + this.port);
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStreamDecorator;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStreamDecorator;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public Object clone() {
        Connection connection = this.cloneImpl();
        connection.setConnectionResetListener(this.connectionResetListener);
        if (this.host != null) {
            connection.setHost(this.host);
        }
        connection.setPort(this.port);
        return connection;
    }

    protected Connection cloneImpl() {
        ConnectionImpl connectionImpl = new ConnectionImpl();
        connectionImpl.setSSLManager(this.sslManager);
        return connectionImpl;
    }

    private void notifyConnectionResetListener() {
        if (this.connectionResetListener != null) {
            this.connectionResetListener.onConnectionReset(this);
        }
    }

    private void streamException(IOException iOException) {
        LOG.warn(iOException);
        try {
            this.disconnect();
        }
        catch (IOException iOException2) {
            // empty catch block
        }
        this.notifyConnectionResetListener();
    }

    private void inputStreamException(IOException iOException) {
        this.streamException(iOException);
    }

    private void outputStreamException(IOException iOException) {
        this.streamException(iOException);
    }

    private class OutputStreamDecorator
    extends OutputStream {
        private OutputStreamDecorator() {
        }

        @Override
        public void write(int n) {
            try {
                ConnectionImpl.this.socket.getOutputStream().write(n);
                ConnectionImpl.this.socket.getOutputStream().write(0);
            }
            catch (IOException iOException) {
                ConnectionImpl.this.outputStreamException(iOException);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Override
        public void write(byte[] byArray) {
            try {
                ConnectionImpl.this.socket.getOutputStream().write(byArray);
                ConnectionImpl.this.socket.getOutputStream().write(0);
            }
            catch (IOException iOException) {
                ConnectionImpl.this.outputStreamException(iOException);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            try {
                ConnectionImpl.this.socket.getOutputStream().write(byArray, n, n2);
                ConnectionImpl.this.socket.getOutputStream().write(0);
            }
            catch (IOException iOException) {
                ConnectionImpl.this.outputStreamException(iOException);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private class InputStreamDecorator
    extends InputStream {
        private boolean canRead = false;
        private Object sync = new Object();

        private InputStreamDecorator() {
        }

        public void lock() {
            this.canRead = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            this.canRead = true;
            Object object = this.sync;
            synchronized (object) {
                this.sync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() {
            while (!this.canRead) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return 0;
                    }
                }
            }
            try {
                int n = ConnectionImpl.this.socket.getInputStream().read();
                System.out.println("Read 1 byte from buffer");
                if (n == -1) {
                    throw new IOException("Connection closed");
                }
                return n;
            }
            catch (IOException iOException) {
                ConnectionImpl.this.inputStreamException(iOException);
                return 0;
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            while (!this.canRead) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return 0;
                    }
                }
            }
            try {
                int n3 = ConnectionImpl.this.socket.getInputStream().read(byArray, n, n2);
                if (n3 == -1) {
                    throw new IOException("Connection closed");
                }
                return n3;
            }
            catch (IOException iOException) {
                ConnectionImpl.this.inputStreamException(iOException);
                throw iOException;
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
        }
    }
}

