/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.storage.impl;

import biz.netup.control.storage.Entity;
import biz.netup.control.storage.Settings;
import biz.netup.control.storage.Storage;
import biz.netup.control.storage.StorageEvent;
import biz.netup.control.storage.StorageListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.garret.perst.FieldIndex;
import org.garret.perst.GenericIndex;
import org.garret.perst.IFile;
import org.garret.perst.IPersistent;
import org.garret.perst.ITable;
import org.garret.perst.Index;
import org.garret.perst.IterableIterator;
import org.garret.perst.MemoryUsage;
import org.garret.perst.NullFile;
import org.garret.perst.Query;

public class StorageImpl
extends org.garret.perst.impl.StorageImpl
implements Storage {
    private static final Logger LOGGER = Logger.getLogger(StorageImpl.class);
    public static boolean useRelation = false;
    static final String SETTINGS_FILENAME = "settings.xml";
    protected static StorageImpl instance;
    private HashMap<Class<? extends Entity>, ITable<Entity>> tables = new HashMap();
    private HashMap<Class<? extends Entity>, GenericIndex<IPersistent>> indexes = new HashMap();
    Index<IPersistent> metadata;
    private HashMap<Class<? extends Entity>, Vector<Listener>> listeners = new HashMap();
    public Vector<StorageEvent> events = new Vector();

    protected StorageImpl() {
        this.setProperty("perst.concurrent.iterator", Boolean.TRUE);
        this.open((IFile)new NullFile(), 0);
        FileInputStream fileInputStream = null;
        Reader reader = null;
        try {
            fileInputStream = new FileInputStream(SETTINGS_FILENAME);
            reader = new InputStreamReader((InputStream)fileInputStream, "utf-8");
            this.importXML(reader);
        }
        catch (Exception exception) {
            try {
                if (null != reader) {
                    reader.close();
                }
                if (null != fileInputStream) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.reload_metadata();
    }

    public static void init() {
        if (null != instance) {
            instance.close();
        }
        instance = new StorageImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void modifyObject(IPersistent iPersistent) {
        if (0 != iPersistent.getOid() && iPersistent instanceof Entity) {
            Vector<StorageEvent> vector = this.events;
            synchronized (vector) {
                this.events.add(new StorageEvent(iPersistent.getClass(), (Entity)iPersistent, 2));
            }
        }
        super.modifyObject(iPersistent);
    }

    public static Storage getInstance() {
        return instance;
    }

    @Override
    public synchronized void addListener(Class<? extends Entity> clazz, int n, StorageListener storageListener) {
        Vector<Listener> vector = this.listeners.get(clazz);
        if (vector == null) {
            vector = new Vector();
            this.listeners.put(clazz, vector);
        }
        vector.add(new Listener(n, storageListener));
    }

    @Override
    public synchronized void removeListener(Class<? extends Entity> clazz, StorageListener storageListener) {
        Vector<Listener> vector = this.listeners.get(clazz);
        if (vector != null) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                if (vector.get((int)i).listener != storageListener) continue;
                vector.remove(i);
            }
        }
    }

    public void fireEvent(StorageEvent storageEvent) {
        this.events.add(storageEvent);
    }

    @Override
    public void beginTransaction() {
    }

    @Override
    public synchronized void commit() {
        final Vector<StorageEvent> vector = this.events;
        this.events = new Vector();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (StorageEvent storageEvent : vector) {
                    Vector vector2 = null;
                    for (Class<?> clazz = storageEvent.getObject().getClass(); vector2 == null && clazz != null; clazz = clazz.getSuperclass()) {
                        vector2 = (Vector)StorageImpl.this.listeners.get(clazz);
                    }
                    int n = storageEvent.getEventType();
                    if (vector2 == null) continue;
                    for (Listener listener : (Vector)vector2.clone()) {
                        if ((listener.eventMask & n) == 0) continue;
                        try {
                            listener.listener.storageChanged(storageEvent);
                        }
                        catch (Exception exception) {
                            LOGGER.error("Exception thrown in commit()", exception);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() {
        super.rollback();
        this.reload_metadata();
        Vector<StorageEvent> vector = this.events;
        synchronized (vector) {
            this.events.clear();
        }
    }

    @Override
    public boolean add(Entity entity) {
        return this.add(entity.getClass(), entity);
    }

    @Override
    public synchronized boolean add(Class<? extends Entity> clazz, Entity entity) {
        Object object = this.tables.get(clazz);
        if (object == null) {
            object = useRelation ? this.createRelation((IPersistent)this.metadata) : this.createSortedCollection(true);
            this.tables.put(clazz, (ITable<Entity>)object);
            this.metadata.put((Object)clazz.getName(), (IPersistent)object);
            try {
                FieldIndex fieldIndex = this.createFieldIndex(clazz, "id", false);
                this.indexes.put(clazz, (GenericIndex<IPersistent>)fieldIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.makePersistent((IPersistent)entity);
        boolean bl = object.add((Object)entity);
        if (bl) {
            FieldIndex fieldIndex = (FieldIndex)this.indexes.get(clazz);
            if (null != fieldIndex) {
                fieldIndex.put((IPersistent)entity);
            }
            this.fireEvent(new StorageEvent(entity.getClass(), entity, 1));
        }
        return bl;
    }

    @Override
    public boolean remove(Entity entity) {
        return this.remove(entity.getClass(), entity);
    }

    public synchronized boolean remove(Class<? extends Entity> clazz, Entity entity) {
        ITable<Entity> iTable = this.tables.get(clazz);
        if (iTable == null) {
            return false;
        }
        boolean bl = iTable.remove((Object)entity);
        if (bl) {
            GenericIndex<IPersistent> genericIndex = this.indexes.get(clazz);
            if (null != genericIndex) {
                try {
                    ((FieldIndex)genericIndex).remove((IPersistent)entity);
                }
                catch (Exception exception) {
                    LOGGER.debug("Can't delete entitiy from index possible index field changed");
                }
            }
            this.fireEvent(new StorageEvent(entity.getClass(), entity, 4));
        }
        return bl;
    }

    @Override
    public <T extends Entity> Iterator<T> getEntities(Class<T> clazz) {
        ITable<Entity> iTable = this.tables.get(clazz);
        if (iTable != null) {
            return iTable.iterator();
        }
        return new Vector().iterator();
    }

    @Override
    public <T extends Entity> Iterator<? extends T> select(Class<T> clazz, String string) {
        ITable<Entity> iTable = this.tables.get(clazz);
        if (iTable != null) {
            Query query = this.createQuery();
            GenericIndex<IPersistent> genericIndex = this.indexes.get(clazz);
            if (null != genericIndex) {
                query.addIndex("id", genericIndex);
                return query.select(clazz, genericIndex.iterator(), string);
            }
            return iTable.select(clazz, string);
        }
        return new Vector().iterator();
    }

    private Class<?> loadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Thread.currentThread().getContextClassLoader().loadClass(string);
    }

    private void reload_metadata() {
        this.tables.clear();
        this.metadata = (Index)this.getRoot();
        if (this.metadata == null) {
            this.metadata = this.createIndex(String.class, true);
            this.setRoot((IPersistent)this.metadata);
        }
        IterableIterator iterableIterator = this.metadata.entryIterator();
        while (iterableIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterableIterator.next();
            try {
                Class<?> clazz = this.loadClass((String)entry.getKey());
                this.tables.put(clazz, (ITable<Entity>)((ITable)entry.getValue()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
    }

    public void saveSettings() {
        Map.Entry<Class<? extends Entity>, ITable<Entity>> entry2;
        for (Map.Entry<Class<? extends Entity>, ITable<Entity>> entry2 : this.tables.entrySet()) {
            if (Settings.class.isAssignableFrom(entry2.getKey())) continue;
            try {
                this.metadata.remove(((Class)entry2.getKey()).getName());
            }
            catch (Exception exception) {
                LOGGER.error("Can't delete " + ((Class)entry2.getKey()).getName() + " from storage", exception);
            }
        }
        entry2 = null;
        Writer writer = null;
        try {
            entry2 = new FileOutputStream(SETTINGS_FILENAME);
            writer = new OutputStreamWriter((OutputStream)((Object)entry2), "utf-8");
            this.exportXML(writer);
        }
        catch (Exception exception) {
            try {
                if (null != writer) {
                    writer.close();
                }
                if (null != entry2) {
                    ((FileOutputStream)((Object)entry2)).close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void logDebug() {
        HashMap hashMap = this.getMemoryDump();
        Logger logger = Logger.getLogger(this.getClass());
        logger.debug("Memory usage: ----------------------------------------------");
        for (MemoryUsage memoryUsage : hashMap.values()) {
            logger.debug("" + memoryUsage.cls.getName() + " inst " + memoryUsage.nInstances + " alloc " + memoryUsage.allocatedSize + " tot " + memoryUsage.totalSize);
        }
    }

    private static class Listener {
        int eventMask;
        StorageListener listener;

        Listener(int n, StorageListener storageListener) {
            this.eventMask = n;
            this.listener = storageListener;
        }
    }
}

