/*
 * Decompiled with CFR 0.152.
 */
package biz.netup.control.storage;

import biz.netup.control.event.Event;
import biz.netup.control.event.Transaction;
import biz.netup.control.handler.TransactionListener;
import biz.netup.control.handler.TransactionListenerException;
import biz.netup.control.storage.Settings;
import biz.netup.control.xml.parser.XMLParserException;
import biz.netup.control.xml.parser.XMLParserExceptionListener;
import biz.netup.control.xml.parser.impl.TransactionStreamParser;
import biz.netup.control.xml.serializer.impl.TransactionStreamSerializerImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ScheduledTransaction
extends Settings {
    static final long MSEC_IN_DAY = 86400000L;
    static final long MSEC_IN_HOUR = 3600000L;
    static final long MSEC_IN_MIN = 60000L;
    static final long MSEC_IN_SEC = 1000L;
    String id;
    boolean persistent;
    String crontab;
    public String transaction_s;
    transient Date next_execution_date;
    protected transient long min_execution_period;
    protected transient int[] seconds;
    protected transient int[] minutes;
    protected transient int[] hours;
    protected transient int[] days_of_month;
    protected transient int[] months;
    protected transient int[] days_of_week;
    public transient Transaction transaction;

    public ScheduledTransaction() {
    }

    public ScheduledTransaction(String string, String string2) {
        this.crontab = string2;
        this.transaction_s = string;
        TransactionStreamParser transactionStreamParser = new TransactionStreamParser();
        transactionStreamParser.setTransactionListener(new TransactionListener(){

            @Override
            public void onTransaction(Transaction transaction) {
                ScheduledTransaction.this.transaction = transaction;
            }
        });
        transactionStreamParser.setExceptionListener(new XMLParserExceptionListener(){

            @Override
            public void onException(XMLParserException xMLParserException) {
                throw new IllegalArgumentException("Broken 'transaction'.", xMLParserException);
            }
        });
        try {
            transactionStreamParser.parse(new ByteArrayInputStream(string.getBytes()));
        }
        catch (IOException iOException) {
            Logger.getLogger(ScheduledTransaction.class).error("", iOException);
        }
        if (this.transaction == null) {
            throw new IllegalArgumentException("Broken 'transaction'.");
        }
        this.parseCrontab();
    }

    public ScheduledTransaction(Transaction transaction, String string) {
        this.crontab = string;
        this.transaction = transaction;
        TransactionStreamSerializerImpl transactionStreamSerializerImpl = new TransactionStreamSerializerImpl();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        transactionStreamSerializerImpl.setOutputStream(byteArrayOutputStream);
        try {
            transactionStreamSerializerImpl.onTransaction(transaction);
        }
        catch (TransactionListenerException transactionListenerException) {
            Logger.getLogger(ScheduledTransaction.class).error("Can't serialize transaction", transactionListenerException);
        }
        this.transaction_s = ((Object)byteArrayOutputStream).toString();
        this.parseCrontab();
    }

    public ScheduledTransaction(Event event, String string) {
        this.crontab = string;
        this.transaction = new Transaction();
        this.transaction.addEvent(event);
        TransactionStreamSerializerImpl transactionStreamSerializerImpl = new TransactionStreamSerializerImpl();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        transactionStreamSerializerImpl.setOutputStream(byteArrayOutputStream);
        try {
            transactionStreamSerializerImpl.onTransaction(this.transaction);
        }
        catch (TransactionListenerException transactionListenerException) {
            Logger.getLogger(ScheduledTransaction.class).error("", transactionListenerException);
        }
        this.transaction_s = byteArrayOutputStream.toString();
        this.parseCrontab();
    }

    private void parseCrontab() {
        try {
            String string = this.crontab.trim();
            if (string.indexOf("every") != -1) {
                this.min_execution_period = this.parseEvery(string.substring(string.indexOf("every") + 5));
                string = string.substring(0, string.indexOf("every"));
            }
            if (string.trim().length() > 0) {
                if (!string.substring(0, 3).equals("at ")) {
                    throw new IllegalArgumentException("");
                }
                this.parseAt(string.substring(3));
            } else {
                this.parseAt("");
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Something wrong with crontab entry: " + this.crontab, exception);
        }
    }

    long parseEvery(String string) {
        int n = 0;
        long l = 0L;
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c >= '0' && c <= '9') continue;
            long l2 = Long.parseLong(string.substring(n, i).trim());
            n = i + 1;
            switch (c) {
                case 's': {
                    l += l2 * 1000L;
                    continue block6;
                }
                case 'm': {
                    l += l2 * 60000L;
                    continue block6;
                }
                case 'h': {
                    l += l2 * 3600000L;
                    continue block6;
                }
                case 'd': {
                    l += l2 * 86400000L;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (string.substring(n).trim().length() != 0) {
            throw new IllegalArgumentException();
        }
        return l;
    }

    long parseAt(String string) {
        long l = 0L;
        TreeMap<Integer, Boolean> treeMap = new TreeMap<Integer, Boolean>();
        TreeMap<Integer, Boolean> treeMap2 = new TreeMap<Integer, Boolean>();
        TreeMap<Integer, Boolean> treeMap3 = new TreeMap<Integer, Boolean>();
        TreeMap<Integer, Boolean> treeMap4 = new TreeMap<Integer, Boolean>();
        TreeMap<Integer, Boolean> treeMap5 = new TreeMap<Integer, Boolean>();
        TreeMap<Integer, Boolean> treeMap6 = new TreeMap<Integer, Boolean>();
        int n = 0;
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c >= '0' && c <= '9') continue;
            int n2 = Integer.parseInt(string.substring(n, i).trim());
            n = i + 1;
            switch (c) {
                case 's': {
                    treeMap.put(n2, true);
                    continue block8;
                }
                case 'm': {
                    treeMap2.put(n2, true);
                    continue block8;
                }
                case 'h': {
                    treeMap3.put(n2, true);
                    continue block8;
                }
                case 'd': {
                    treeMap4.put(n2, true);
                    continue block8;
                }
                case 'M': {
                    treeMap5.put(n2, true);
                    continue block8;
                }
                case 'w': {
                    treeMap6.put(n2, true);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (string.substring(n).trim().length() != 0) {
            throw new IllegalArgumentException();
        }
        this.seconds = this.MapToArray(treeMap);
        this.minutes = this.MapToArray(treeMap2);
        this.hours = this.MapToArray(treeMap3);
        this.days_of_week = this.MapToArray(treeMap6);
        this.days_of_month = this.MapToArray(treeMap4);
        this.months = this.MapToArray(treeMap5);
        return l;
    }

    private int[] MapToArray(Map<Integer, Boolean> map) {
        int[] nArray = new int[map.size()];
        int n = 0;
        for (Integer n2 : map.keySet()) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public Date getNextExecutionDate(Date date) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.next_execution_date != null && this.next_execution_date.getTime() >= date.getTime()) {
            return this.next_execution_date;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 999);
        if (this.next_execution_date != null) {
            date = calendar.getTime();
            if (date.getTime() - this.next_execution_date.getTime() < this.min_execution_period) {
                date = new Date(this.next_execution_date.getTime() + this.min_execution_period);
            }
            calendar.setTime(date);
            calendar.set(14, 999);
        }
        if ((n4 = this.getNext(this.seconds, calendar.get(13))) == -1) {
            n4 = this.getNext(this.seconds, 0);
            calendar.add(12, 1);
        }
        if ((n3 = this.getNext(this.minutes, calendar.get(12))) == -1) {
            n4 = this.getNext(this.seconds, 0);
            n3 = this.getNext(this.minutes, 0);
            calendar.add(11, 1);
        }
        if ((n2 = this.getNext(this.hours, calendar.get(11))) == -1) {
            n4 = this.getNext(this.seconds, 0);
            n3 = this.getNext(this.minutes, 0);
            n2 = this.getNext(this.hours, 0);
            calendar.add(5, 1);
        }
        if ((n = this.getNext(this.days_of_month, calendar.get(5) - 1)) == -1) {
            n4 = this.getNext(this.seconds, 0);
            n3 = this.getNext(this.minutes, 0);
            n2 = this.getNext(this.hours, 0);
            n = this.getNext(this.days_of_month, 0);
            calendar.add(2, 1);
        }
        boolean bl = false;
        while (!bl) {
            if (this.checkDayValidInMonth(n + 1, calendar.get(2), calendar.get(1))) {
                bl = true;
                continue;
            }
            calendar.add(2, 1);
        }
        int n5 = this.getNext(this.months, calendar.get(2));
        if (n5 == -1) {
            n3 = this.getNext(this.minutes, 0);
            n2 = this.getNext(this.hours, 0);
            n = this.getNext(this.days_of_month, 0);
            n5 = this.getNext(this.months, 0);
            calendar.add(1, 1);
        }
        Date date2 = this.getTime(n4, n3, n2, n + 1, n5, calendar.get(1));
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        if (this.days_of_week.length == 0 || Arrays.binarySearch(this.days_of_week, calendar2.get(7) - 1) >= 0) {
            this.next_execution_date = calendar2.getTime();
            return this.next_execution_date;
        }
        calendar2.add(6, 1);
        return this.getNextExecutionDate(calendar2.getTime());
    }

    int getNext(int[] nArray, int n) {
        if (nArray.length == 0) {
            return n;
        }
        for (int n2 : nArray) {
            if (n2 < n) continue;
            return n2;
        }
        return -1;
    }

    private Date getTime(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.set(n6, n5, n4, n3, n2, n);
            calendar.set(14, 999);
            return calendar.getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean checkDayValidInMonth(int n, int n2, int n3) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.set(5, n);
            calendar.set(2, n2);
            calendar.set(1, n3);
            calendar.getTime();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public synchronized void load() {
        try {
            this.parseCrontab();
        }
        catch (Exception exception) {
            Logger.getLogger(ScheduledTransaction.class).error("", exception);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ScheduledTransaction)) {
            return false;
        }
        if (super.equals(object)) {
            return true;
        }
        ScheduledTransaction scheduledTransaction = (ScheduledTransaction)object;
        return scheduledTransaction.transaction_s.equals(this.transaction_s) && scheduledTransaction.crontab.equals(this.crontab);
    }
}

